//
//  Fragment Shader
//

uniform sampler2D EarthDay; 
uniform sampler2D EarthNight;

 
varying float Diffuse; 
varying vec3  Specular; 
varying vec2  TexCoord;
 
void main() 
{ 
    // Monochrome cloud cover value will be in clouds.r 
    // Gloss value will be in clouds.g 
    // clouds.b will be unused 
 
    vec3 daytime   = texture2D(EarthDay, TexCoord).rgb * Diffuse * 2.2;                         
    vec3 nighttime = texture2D(EarthNight, TexCoord).rgb * 0.5;                         
 
    vec3 color = daytime;
     


   float b = 0.01;
       
   if (nighttime.r < 0.2)  // Schwellwert
   {
      nighttime.r = pow(nighttime.r, 1.42);
      nighttime.g = pow(nighttime.g, 1.42);
      nighttime.b = pow(nighttime.b, 1.42);
   }


  // color = daytime;
   
   if (Diffuse < b - 0.001)
   {
     color = nighttime;
   }
   else 
   if (Diffuse < b)
   {
     color = mix(nighttime, daytime, (Diffuse - (b-0.001)) * 1000.0);
   }

    
    	    
    color.r = pow(color.r, 0.7);  
    color.g = pow(color.g, 0.7);
    color.b = pow(color.b, 0.7);
 
    gl_FragColor = vec4(color, 1.0);
}